/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWInformationStackDialog;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;

public class VWAdminInformationStack {
    private Vector m_vErrors = new Vector();
    private VWAdminResultPane m_resultsPane;
    private int[] m_selectedRows;
    private VWAdminResultTableModelBase m_tableModel;
    protected Vector m_wobsList = new Vector();
    protected VWParticipant m_logonUser = null;
    protected Frame m_parentFrame = null;

    public VWAdminInformationStack(VWAdminResultPane resultsPane) {
        this.m_resultsPane = resultsPane;
        this.m_tableModel = resultsPane.getTableModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_informationStackTitle, 1, null);
            return;
        }
        if (this.m_selectedRows.length == 0) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_noRowSelected, VWResource.s_informationStackTitle, 1, null);
            return;
        }
        this.buildWobsList(this.m_selectedRows);
        VWInformationStackDialog stackDlg = new VWInformationStackDialog(this.m_wobsList, this.m_parentFrame);
        stackDlg.setVisible(true);
        this.removeReferences();
    }

    private void buildWobsList(int[] rows) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWWorkObject wob;
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                if (woData == null || (wob = woData.getWob()) == null) continue;
                this.m_wobsList.addElement(wob);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeReferences() {
        if (this.m_wobsList != null) {
            this.m_wobsList.removeAllElements();
        }
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

